#include <bits/stdc++.h>
#define ll long long
#define MAXN 300005

using namespace std;

typedef __int128 i128;
typedef complex<ll> Vec;
#define X real()
#define Y imag()

int N;
Vec a[MAXN];
bool curr[MAXN], best[MAXN];
ll bestVal = 0;

random_device rd;
mt19937 rng(rd());

const int ITERATIONS = 80;
const int IMPROVE = 3;

i128 square(Vec v)
{
  return (i128)v.X * v.X + (i128)v.Y * v.Y;
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N;

  for (int i = 0; i < N; i++)
  {
    ll x, y;
    cin >> x >> y;
    a[i] = Vec(x, y);
  }

  for (int iter = 0; iter < ITERATIONS; iter++)
  {
    ll rx = 0, ry = 0;
    while (rx == 0 && ry == 0)
    {
      rx = rng() % 2001 - 1000;
      ry = rng() % 2001 - 1000;
    }

    Vec R = Vec(rx, ry);
    Vec S = Vec(0, 0);

    for (int i = 0; i < N; i++)
    {
      ll p = a[i].X * R.X + a[i].Y * R.Y;
      if (p > 0)
      {
        curr[i] = true;
        S += a[i];
      }
      else
      {
        curr[i] = false;
      }
    }

    for (int improve = 0; improve < IMPROVE; improve++)
    {
      bool ok = false;
      i128 val = square(S);

      for (int i = 0; i < N; i++)
      {
        Vec newS = curr[i] ? (S - a[i]) : (S + a[i]);
        i128 newVal = square(newS);
        if (newVal > val)
        {
          val = newVal;
          S = newS;
          curr[i] = !curr[i];
          ok = true;
        }
      }

      if (!ok)
      {
        break;
      }
    }

    i128 val = square(S);
    if (val > bestVal)
    {
      bestVal = val;
      for (int i = 0; i < N; i++)
      {
        best[i] = curr[i];
      }
    }
  }

  vector<int> res;
  for (int i = 0; i < N; i++)
  {
    if (best[i])
    {
      res.push_back(i + 1);
    }
  }

  cout << res.size() << "\n";
  for (int i : res)
  {
    cout << i << " ";
  }
  cout << "\n";
}